#########################################################################################
# Package        HiPi::Graphics::BitmapFont::Mono33
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::Mono33;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 33;
my $line_spacing = 4;
my $name = 'Mono 33';
my $space_width = 19;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 3, 
        'xoffset'  => 8, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 9, 
        'xoffset'  => 5, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 19, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xC3, 0x80, ##          00    000  
            0x00, 0xC3, 0x00, ##          00    00   
            0x00, 0xC3, 0x00, ##          00    00   
            0x01, 0xC7, 0x00, ##         000   000   
            0x01, 0xC7, 0x00, ##         000   000   
            0x01, 0x86, 0x00, ##         00    00    
            0x01, 0x86, 0x00, ##         00    00    
            0x3F, 0xFF, 0xE0, ##    00000000000000000
            0x3F, 0xFF, 0xE0, ##    00000000000000000
            0x03, 0x0C, 0x00, ##        00    00     
            0x03, 0x0C, 0x00, ##        00    00     
            0x07, 0x1C, 0x00, ##       000   000     
            0x07, 0x1C, 0x00, ##       000   000     
            0x06, 0x18, 0x00, ##       00    00      
            0xFF, 0xFF, 0x80, ##  00000000000000000  
            0xFF, 0xFF, 0x80, ##  00000000000000000  
            0x0C, 0x38, 0x00, ##      00    000      
            0x0C, 0x30, 0x00, ##      00    00       
            0x0C, 0x30, 0x00, ##      00    00       
            0x1C, 0x70, 0x00, ##     000   000       
            0x1C, 0x70, 0x00, ##     000   000       
            0x18, 0x60, 0x00, ##     00    00        
            0x18, 0x60, 0x00, ##     00    00        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 14, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x0F, 0xE0, ##      0000000   
            0x3F, 0xF0, ##    0000000000  
            0x73, 0x30, ##   000  00  00  
            0xE3, 0x00, ##  000   00      
            0xE3, 0x00, ##  000   00      
            0xE3, 0x00, ##  000   00      
            0xE3, 0x00, ##  000   00      
            0xF3, 0x00, ##  0000  00      
            0x7B, 0x00, ##   0000 00      
            0x7F, 0xC0, ##   000000000    
            0x1F, 0xF0, ##     000000000  
            0x03, 0xF8, ##        0000000 
            0x03, 0x38, ##        00  000 
            0x03, 0x1C, ##        00   000
            0x03, 0x1C, ##        00   000
            0x03, 0x1C, ##        00   000
            0x03, 0x1C, ##        00   000
            0x83, 0x1C, ##  0     00   000
            0xE3, 0x38, ##  000   00  000 
            0xFF, 0xF0, ##  000000000000  
            0x3F, 0xE0, ##    000000000   
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 18, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x1E, 0x00, 0x00, ##     0000           
            0x7F, 0x80, 0x00, ##   00000000         
            0xE1, 0x80, 0x00, ##  000    00         
            0xC0, 0xC0, 0x00, ##  00      00        
            0xC0, 0xC0, 0x00, ##  00      00        
            0xC0, 0xC0, 0x00, ##  00      00        
            0xE1, 0xC0, 0x80, ##  000    000      0 
            0x7F, 0x83, 0x80, ##   00000000     000 
            0x1E, 0x0F, 0x00, ##     0000     0000  
            0x00, 0x78, 0x00, ##           0000     
            0x01, 0xE0, 0x00, ##         0000       
            0x07, 0x80, 0x00, ##       0000         
            0x3C, 0x1E, 0x00, ##    0000     0000   
            0x70, 0x7F, 0x80, ##   000     00000000 
            0x40, 0x61, 0x80, ##   0       00    00 
            0x00, 0xC0, 0xC0, ##          00      00
            0x00, 0xC0, 0xC0, ##          00      00
            0x00, 0xC0, 0xC0, ##          00      00
            0x00, 0xC0, 0xC0, ##          00      00
            0x00, 0x61, 0x80, ##           00    00 
            0x00, 0x7F, 0x80, ##           00000000 
            0x00, 0x1E, 0x00, ##             0000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 18, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xF0, 0x00, ##        000000      
            0x0F, 0xF8, 0x00, ##      000000000     
            0x1E, 0x18, 0x00, ##     0000    00     
            0x1C, 0x00, 0x00, ##     000            
            0x1C, 0x00, 0x00, ##     000            
            0x1C, 0x00, 0x00, ##     000            
            0x1C, 0x00, 0x00, ##     000            
            0x0E, 0x00, 0x00, ##      000           
            0x07, 0x00, 0x00, ##       000          
            0x1F, 0x00, 0x00, ##     00000          
            0x3F, 0x80, 0x00, ##    0000000         
            0x79, 0xC1, 0xC0, ##   0000  000     000
            0x71, 0xC1, 0xC0, ##   000   000     000
            0xE0, 0xE1, 0xC0, ##  000     000    000
            0xE0, 0x71, 0xC0, ##  000      000   000
            0xE0, 0x79, 0xC0, ##  000      0000  000
            0xE0, 0x3B, 0x80, ##  000       000 000 
            0xE0, 0x1F, 0x80, ##  000        000000 
            0xF0, 0x0F, 0x00, ##  0000        0000  
            0x78, 0x0E, 0x00, ##   0000       000   
            0x3C, 0x1F, 0x00, ##    0000     00000  
            0x1F, 0xFB, 0x80, ##     0000000000 000 
            0x07, 0xE3, 0xC0, ##       000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 3, 
        'xoffset'  => 8, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 7, 
        'xoffset'  => 7, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x0E, ##      000
            0x0C, ##      00 
            0x1C, ##     000 
            0x18, ##     00  
            0x38, ##    000  
            0x38, ##    000  
            0x70, ##   000   
            0x70, ##   000   
            0x70, ##   000   
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0x70, ##   000   
            0x70, ##   000   
            0x70, ##   000   
            0x30, ##    00   
            0x38, ##    000  
            0x38, ##    000  
            0x1C, ##     000 
            0x1C, ##     000 
            0x0E, ##      000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 7, 
        'xoffset'  => 6, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000    
            0x60, ##   00    
            0x70, ##   000   
            0x30, ##    00   
            0x38, ##    000  
            0x38, ##    000  
            0x1C, ##     000 
            0x1C, ##     000 
            0x1C, ##     000 
            0x0C, ##      00 
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x1C, ##     000 
            0x1C, ##     000 
            0x1C, ##     000 
            0x18, ##     00  
            0x38, ##    000  
            0x38, ##    000  
            0x70, ##   000   
            0x70, ##   000   
            0xE0, ##  000    
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 14, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0xC3, 0x0C, ##  00    00    00
            0x73, 0x38, ##   000  00  000 
            0x1F, 0xE0, ##     00000000   
            0x0F, 0xC0, ##      000000    
            0x0F, 0xC0, ##      000000    
            0x1F, 0xE0, ##     00000000   
            0x73, 0x38, ##   000  00  000 
            0xC3, 0x0C, ##  00    00    00
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 6, 
        'xoffset'  => 6, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x38, ##    000 
            0x78, ##   0000 
            0x70, ##   000  
            0x70, ##   000  
            0x60, ##   00   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 8, 
        'xoffset'  => 6, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 4, 
        'xoffset'  => 8, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x0E, ##              000
            0x00, 0x1C, ##             000 
            0x00, 0x1C, ##             000 
            0x00, 0x38, ##            000  
            0x00, 0x38, ##            000  
            0x00, 0x70, ##           000   
            0x00, 0x70, ##           000   
            0x00, 0xE0, ##          000    
            0x00, 0xE0, ##          000    
            0x01, 0xC0, ##         000     
            0x01, 0xC0, ##         000     
            0x01, 0xC0, ##         000     
            0x03, 0x80, ##        000      
            0x03, 0x80, ##        000      
            0x07, 0x00, ##       000       
            0x07, 0x00, ##       000       
            0x0E, 0x00, ##      000        
            0x0E, 0x00, ##      000        
            0x1C, 0x00, ##     000         
            0x1C, 0x00, ##     000         
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x70, 0x00, ##   000           
            0x70, 0x00, ##   000           
            0x70, 0x00, ##   000           
            0xE0, 0x00, ##  000            
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xC0, ##       00000     
            0x1F, 0xF0, ##     000000000   
            0x3C, 0x78, ##    0000   0000  
            0x38, 0x38, ##    000     000  
            0x70, 0x1C, ##   000       000 
            0x70, 0x1C, ##   000       000 
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE1, 0x8E, ##  000    00   000
            0xE3, 0xCE, ##  000   0000  000
            0xE3, 0xCE, ##  000   0000  000
            0xE1, 0x8E, ##  000    00   000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0x70, 0x1C, ##   000       000 
            0x70, 0x1C, ##   000       000 
            0x38, 0x38, ##    000     000  
            0x3C, 0x78, ##    0000   0000  
            0x1F, 0xF0, ##     000000000   
            0x07, 0xC0, ##       00000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 13, 
        'xoffset'  => 4, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000     
            0xFF, 0x00, ##  00000000     
            0xFF, 0x00, ##  00000000     
            0xC7, 0x00, ##  00   000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0xC0, ##    00000000    
            0xFF, 0xE0, ##  00000000000   
            0xF0, 0x78, ##  0000     0000 
            0x80, 0x38, ##  0         000 
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x38, ##            000 
            0x00, 0x78, ##           0000 
            0x00, 0x70, ##           000  
            0x00, 0xE0, ##          000   
            0x01, 0xE0, ##         0000   
            0x03, 0xC0, ##        0000    
            0x07, 0x80, ##       0000     
            0x0F, 0x00, ##      0000      
            0x1E, 0x00, ##     0000       
            0x3C, 0x00, ##    0000        
            0x78, 0x00, ##   0000         
            0xF0, 0x00, ##  0000          
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0xC0, ##    00000000     
            0x7F, 0xF0, ##   00000000000   
            0x60, 0x78, ##   00      0000  
            0x00, 0x38, ##            000  
            0x00, 0x1C, ##             000 
            0x00, 0x1C, ##             000 
            0x00, 0x1C, ##             000 
            0x00, 0x3C, ##            0000 
            0x00, 0x78, ##           0000  
            0x0F, 0xF0, ##      00000000   
            0x0F, 0xE0, ##      0000000    
            0x00, 0x70, ##           000   
            0x00, 0x18, ##             00  
            0x00, 0x1C, ##             000 
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x1E, ##             0000
            0x80, 0x1C, ##  0          000 
            0xE0, 0x7C, ##  000      00000 
            0xFF, 0xF0, ##  000000000000   
            0x3F, 0xC0, ##    00000000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 17, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x78, 0x00, ##           0000    
            0x00, 0xF8, 0x00, ##          00000    
            0x00, 0xF8, 0x00, ##          00000    
            0x01, 0xF8, 0x00, ##         000000    
            0x01, 0xB8, 0x00, ##         00 000    
            0x03, 0x38, 0x00, ##        00  000    
            0x07, 0x38, 0x00, ##       000  000    
            0x06, 0x38, 0x00, ##       00   000    
            0x0E, 0x38, 0x00, ##      000   000    
            0x1C, 0x38, 0x00, ##     000    000    
            0x18, 0x38, 0x00, ##     00     000    
            0x38, 0x38, 0x00, ##    000     000    
            0x70, 0x38, 0x00, ##   000      000    
            0x60, 0x38, 0x00, ##   00       000    
            0xE0, 0x38, 0x00, ##  000       000    
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x38, 0x00, ##            000    
            0x00, 0x38, 0x00, ##            000    
            0x00, 0x38, 0x00, ##            000    
            0x00, 0x38, 0x00, ##            000    
            0x00, 0x38, 0x00, ##            000    
            0x00, 0x38, 0x00, ##            000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7F, 0xF0, ##   00000000000  
            0x7F, 0xF0, ##   00000000000  
            0x70, 0x00, ##   000          
            0x70, 0x00, ##   000          
            0x70, 0x00, ##   000          
            0x70, 0x00, ##   000          
            0x70, 0x00, ##   000          
            0x7F, 0x80, ##   00000000     
            0x7F, 0xE0, ##   0000000000   
            0x60, 0xF0, ##   00     0000  
            0x00, 0x78, ##           0000 
            0x00, 0x38, ##            000 
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x38, ##            000 
            0x00, 0x38, ##            000 
            0xE0, 0xF0, ##  000     0000  
            0xFF, 0xE0, ##  00000000000   
            0x7F, 0x80, ##   00000000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0xF8, ##        0000000  
            0x0F, 0xF8, ##      000000000  
            0x1C, 0x08, ##     000      0  
            0x38, 0x00, ##    000          
            0x70, 0x00, ##   000           
            0x70, 0x00, ##   000           
            0x60, 0x00, ##   00            
            0xE3, 0xE0, ##  000   00000    
            0xEF, 0xF8, ##  000 000000000  
            0xFC, 0x38, ##  000000    000  
            0xF8, 0x1C, ##  00000      000 
            0xF0, 0x1C, ##  0000       000 
            0xF0, 0x0E, ##  0000        000
            0xF0, 0x0E, ##  0000        000
            0xF0, 0x0E, ##  0000        000
            0xF0, 0x0E, ##  0000        000
            0xF0, 0x0E, ##  0000        000
            0x70, 0x0E, ##   000        000
            0x70, 0x1C, ##   000       000 
            0x78, 0x1C, ##   0000      000 
            0x3C, 0x38, ##    0000    000  
            0x1F, 0xF0, ##     000000000   
            0x07, 0xE0, ##       000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0x00, 0x1C, ##             000 
            0x00, 0x1C, ##             000 
            0x00, 0x3C, ##            0000 
            0x00, 0x38, ##            000  
            0x00, 0x38, ##            000  
            0x00, 0x78, ##           0000  
            0x00, 0x70, ##           000   
            0x00, 0xF0, ##          0000   
            0x00, 0xE0, ##          000    
            0x00, 0xE0, ##          000    
            0x01, 0xE0, ##         0000    
            0x01, 0xC0, ##         000     
            0x03, 0xC0, ##        0000     
            0x03, 0x80, ##        000      
            0x03, 0x80, ##        000      
            0x07, 0x80, ##       0000      
            0x07, 0x00, ##       000       
            0x0F, 0x00, ##      0000       
            0x0E, 0x00, ##      000        
            0x0E, 0x00, ##      000        
            0x1E, 0x00, ##     0000        
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xE0, ##       000000    
            0x1F, 0xF8, ##     0000000000  
            0x3C, 0x3C, ##    0000    0000 
            0x78, 0x1E, ##   0000      0000
            0x70, 0x0E, ##   000        000
            0x70, 0x0E, ##   000        000
            0x70, 0x0E, ##   000        000
            0x70, 0x1C, ##   000       000 
            0x3C, 0x3C, ##    0000    0000 
            0x1F, 0xF0, ##     000000000   
            0x0F, 0xF0, ##      00000000   
            0x18, 0x38, ##     00     000  
            0x30, 0x1C, ##    00       000 
            0x60, 0x0E, ##   00         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0x70, 0x1C, ##   000       000 
            0x78, 0x3C, ##   0000     0000 
            0x3F, 0xF8, ##    00000000000  
            0x0F, 0xE0, ##      0000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xC0, ##      000000     
            0x3F, 0xF0, ##    0000000000   
            0x78, 0x78, ##   0000    0000  
            0x70, 0x3C, ##   000      0000 
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x1E, ##  000        0000
            0xE0, 0x1E, ##  000        0000
            0xE0, 0x1E, ##  000        0000
            0xE0, 0x1E, ##  000        0000
            0x70, 0x3E, ##   000      00000
            0x78, 0x7E, ##   0000    000000
            0x3F, 0xEE, ##    000000000 000
            0x0F, 0xCE, ##      000000  000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x1C, ##             000 
            0x00, 0x1C, ##             000 
            0x00, 0x3C, ##            0000 
            0x00, 0x38, ##            000  
            0x20, 0xF0, ##    0     0000   
            0x3F, 0xE0, ##    000000000    
            0x3F, 0x80, ##    0000000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 4, 
        'xoffset'  => 8, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 6, 
        'xoffset'  => 6, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x38, ##    000 
            0x78, ##   0000 
            0x70, ##   000  
            0x70, ##   000  
            0x60, ##   00   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0x80, ##                 00
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x3F, 0x80, ##            0000000
            0x00, 0xFE, 0x00, ##          0000000  
            0x07, 0xF0, 0x00, ##       0000000     
            0x1F, 0xC0, 0x00, ##     0000000       
            0xFE, 0x00, 0x00, ##  0000000          
            0xF0, 0x00, 0x00, ##  0000             
            0xF8, 0x00, 0x00, ##  00000            
            0x7E, 0x00, 0x00, ##   000000          
            0x1F, 0xC0, 0x00, ##     0000000       
            0x03, 0xF8, 0x00, ##        0000000    
            0x00, 0xFE, 0x00, ##          0000000  
            0x00, 0x1F, 0x80, ##             000000
            0x00, 0x07, 0x80, ##               0000
            0x00, 0x00, 0x80, ##                  0
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x80, 0x00, 0x00, ##  0                
            0xF0, 0x00, 0x00, ##  0000             
            0xFC, 0x00, 0x00, ##  000000           
            0x3F, 0x80, 0x00, ##    0000000        
            0x0F, 0xE0, 0x00, ##      0000000      
            0x01, 0xFC, 0x00, ##         0000000   
            0x00, 0x7F, 0x00, ##           0000000 
            0x00, 0x0F, 0x80, ##              00000
            0x00, 0x0F, 0x80, ##              00000
            0x00, 0x7F, 0x00, ##           0000000 
            0x03, 0xF8, 0x00, ##        0000000    
            0x0F, 0xE0, 0x00, ##      0000000      
            0x7F, 0x00, 0x00, ##   0000000         
            0xFC, 0x00, 0x00, ##  000000           
            0xE0, 0x00, 0x00, ##  000              
            0x80, 0x00, 0x00, ##  0                
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 12, 
        'xoffset'  => 4, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x80, ##    0000000   
            0xFF, 0xC0, ##  0000000000  
            0xE1, 0xE0, ##  000    0000 
            0x80, 0x70, ##  0        000
            0x00, 0x70, ##           000
            0x00, 0x70, ##           000
            0x00, 0x70, ##           000
            0x00, 0xE0, ##          000 
            0x01, 0xE0, ##         0000 
            0x03, 0xC0, ##        0000  
            0x07, 0x80, ##       0000   
            0x07, 0x00, ##       000    
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 18, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xFC, 0x00, ##         0000000    
            0x07, 0xFE, 0x00, ##       0000000000   
            0x0F, 0x07, 0x00, ##      0000     000  
            0x1E, 0x01, 0x80, ##     0000        00 
            0x3C, 0x01, 0x80, ##    0000         00 
            0x38, 0x00, 0xC0, ##    000           00
            0x70, 0x00, 0xC0, ##   000            00
            0x70, 0x3C, 0xC0, ##   000      0000  00
            0x70, 0xFF, 0xC0, ##   000    0000000000
            0xE1, 0xE3, 0xC0, ##  000    0000   0000
            0xE1, 0xC1, 0xC0, ##  000    000     000
            0xE3, 0x80, 0xC0, ##  000   000       00
            0xE3, 0x80, 0xC0, ##  000   000       00
            0xE3, 0x80, 0xC0, ##  000   000       00
            0xE3, 0x80, 0xC0, ##  000   000       00
            0xE3, 0x80, 0xC0, ##  000   000       00
            0xE1, 0xC1, 0xC0, ##  000    000     000
            0xE1, 0xE3, 0xC0, ##  000    0000   0000
            0x70, 0xFF, 0xC0, ##   000    0000000000
            0x70, 0x3C, 0xC0, ##   000      0000  00
            0x78, 0x00, 0x00, ##   0000             
            0x38, 0x00, 0x00, ##    000             
            0x1C, 0x00, 0x00, ##     000            
            0x1E, 0x00, 0x00, ##     0000           
            0x07, 0x81, 0x00, ##       0000      0  
            0x03, 0xFF, 0x00, ##        0000000000  
            0x00, 0xFF, 0x00, ##          00000000  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 18, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xE0, 0x00, ##         0000       
            0x03, 0xE0, 0x00, ##        00000       
            0x03, 0xE0, 0x00, ##        00000       
            0x03, 0x70, 0x00, ##        00 000      
            0x07, 0x70, 0x00, ##       000 000      
            0x07, 0x70, 0x00, ##       000 000      
            0x07, 0x38, 0x00, ##       000  000     
            0x0E, 0x38, 0x00, ##      000   000     
            0x0E, 0x38, 0x00, ##      000   000     
            0x0E, 0x38, 0x00, ##      000   000     
            0x1E, 0x1C, 0x00, ##     0000    000    
            0x1C, 0x1C, 0x00, ##     000     000    
            0x1C, 0x1C, 0x00, ##     000     000    
            0x1C, 0x0E, 0x00, ##     000      000   
            0x38, 0x0E, 0x00, ##    000       000   
            0x3F, 0xFE, 0x00, ##    0000000000000   
            0x3F, 0xFF, 0x00, ##    00000000000000  
            0x70, 0x07, 0x00, ##   000         000  
            0x70, 0x07, 0x00, ##   000         000  
            0x70, 0x07, 0x80, ##   000         0000 
            0xF0, 0x03, 0x80, ##  0000          000 
            0xE0, 0x03, 0x80, ##  000           000 
            0xE0, 0x03, 0xC0, ##  000           0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xC0, ##  0000000000     
            0xFF, 0xF0, ##  000000000000   
            0xE0, 0x78, ##  000      0000  
            0xE0, 0x3C, ##  000       0000 
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x3C, ##  000       0000 
            0xE0, 0x78, ##  000      0000  
            0xFF, 0xF0, ##  000000000000   
            0xFF, 0xF0, ##  000000000000   
            0xE0, 0x38, ##  000       000  
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x3C, ##  000       0000 
            0xFF, 0xF8, ##  0000000000000  
            0xFF, 0xE0, ##  00000000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0xF8, ##        0000000  
            0x0F, 0xFE, ##      00000000000
            0x1E, 0x0E, ##     0000     000
            0x38, 0x02, ##    000         0
            0x70, 0x00, ##   000           
            0x70, 0x00, ##   000           
            0x70, 0x00, ##   000           
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0x70, 0x00, ##   000           
            0x70, 0x00, ##   000           
            0x70, 0x00, ##   000           
            0x38, 0x02, ##    000         0
            0x1E, 0x0E, ##     0000     000
            0x0F, 0xFE, ##      00000000000
            0x03, 0xF8, ##        0000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000      
            0xFF, 0xE0, ##  00000000000    
            0xE0, 0xF0, ##  000     0000   
            0xE0, 0x38, ##  000       000  
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x38, ##  000       000  
            0xE0, 0xF0, ##  000     0000   
            0xFF, 0xE0, ##  00000000000    
            0xFF, 0x80, ##  000000000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 14, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 14, 
        'xoffset'  => 4, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xFF, 0xF8, ##  0000000000000 
            0xFF, 0xF8, ##  0000000000000 
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0xF8, ##        0000000   
            0x0F, 0xFE, ##      00000000000 
            0x1E, 0x0E, ##     0000     000 
            0x38, 0x02, ##    000         0 
            0x38, 0x00, ##    000           
            0x70, 0x00, ##   000            
            0x70, 0x00, ##   000            
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x7F, ##  000      0000000
            0xE0, 0x7F, ##  000      0000000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0x70, 0x07, ##   000         000
            0x70, 0x07, ##   000         000
            0x70, 0x07, ##   000         000
            0x38, 0x07, ##    000        000
            0x1E, 0x0F, ##     0000     0000
            0x0F, 0xFE, ##      00000000000 
            0x03, 0xF8, ##        0000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 13, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xF8, ##      000000000
            0x0F, 0xF8, ##      000000000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x80, 0x70, ##  0        000 
            0xE0, 0xF0, ##  000     0000 
            0xFF, 0xE0, ##  00000000000  
            0x3F, 0x80, ##    0000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 17, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xE0, 0x0F, 0x00, ##  000         0000 
            0xE0, 0x1E, 0x00, ##  000        0000  
            0xE0, 0x3C, 0x00, ##  000       0000   
            0xE0, 0x78, 0x00, ##  000      0000    
            0xE0, 0x70, 0x00, ##  000      000     
            0xE0, 0xE0, 0x00, ##  000     000      
            0xE1, 0xC0, 0x00, ##  000    000       
            0xE3, 0x80, 0x00, ##  000   000        
            0xE7, 0x00, 0x00, ##  000  000         
            0xEF, 0x00, 0x00, ##  000 0000         
            0xFF, 0x00, 0x00, ##  00000000         
            0xFF, 0x80, 0x00, ##  000000000        
            0xF3, 0xC0, 0x00, ##  0000  0000       
            0xE1, 0xC0, 0x00, ##  000    000       
            0xE1, 0xE0, 0x00, ##  000    0000      
            0xE0, 0xF0, 0x00, ##  000     0000     
            0xE0, 0x70, 0x00, ##  000      000     
            0xE0, 0x78, 0x00, ##  000      0000    
            0xE0, 0x3C, 0x00, ##  000       0000   
            0xE0, 0x1C, 0x00, ##  000        000   
            0xE0, 0x1E, 0x00, ##  000        0000  
            0xE0, 0x0F, 0x00, ##  000         0000 
            0xE0, 0x07, 0x80, ##  000          0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xEC, 0x1B, 0x80, ##  000 00     00 000
            0xEC, 0x1B, 0x80, ##  000 00     00 000
            0xEE, 0x3B, 0x80, ##  000 000   000 000
            0xE6, 0x33, 0x80, ##  000  00   00  000
            0xE6, 0x33, 0x80, ##  000  00   00  000
            0xE7, 0x73, 0x80, ##  000  000 000  000
            0xE3, 0x63, 0x80, ##  000   00 00   000
            0xE3, 0x63, 0x80, ##  000   00 00   000
            0xE3, 0xE3, 0x80, ##  000   00000   000
            0xE1, 0xC3, 0x80, ##  000    000    000
            0xE1, 0xC3, 0x80, ##  000    000    000
            0xE0, 0x03, 0x80, ##  000           000
            0xE0, 0x03, 0x80, ##  000           000
            0xE0, 0x03, 0x80, ##  000           000
            0xE0, 0x03, 0x80, ##  000           000
            0xE0, 0x03, 0x80, ##  000           000
            0xE0, 0x03, 0x80, ##  000           000
            0xE0, 0x03, 0x80, ##  000           000
            0xE0, 0x03, 0x80, ##  000           000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0x0E, ##  0000        000
            0xF8, 0x0E, ##  00000       000
            0xF8, 0x0E, ##  00000       000
            0xF8, 0x0E, ##  00000       000
            0xFC, 0x0E, ##  000000      000
            0xEC, 0x0E, ##  000 00      000
            0xEE, 0x0E, ##  000 000     000
            0xEE, 0x0E, ##  000 000     000
            0xE7, 0x0E, ##  000  000    000
            0xE7, 0x0E, ##  000  000    000
            0xE3, 0x0E, ##  000   00    000
            0xE3, 0x8E, ##  000   000   000
            0xE1, 0x8E, ##  000    00   000
            0xE1, 0xCE, ##  000    000  000
            0xE1, 0xCE, ##  000    000  000
            0xE0, 0xEE, ##  000     000 000
            0xE0, 0xEE, ##  000     000 000
            0xE0, 0x6E, ##  000      00 000
            0xE0, 0x7E, ##  000      000000
            0xE0, 0x3E, ##  000       00000
            0xE0, 0x3E, ##  000       00000
            0xE0, 0x3E, ##  000       00000
            0xE0, 0x1E, ##  000        0000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xC0, ##       00000     
            0x1F, 0xF0, ##     000000000   
            0x3C, 0x78, ##    0000   0000  
            0x70, 0x38, ##   000      000  
            0x70, 0x1C, ##   000       000 
            0x70, 0x1C, ##   000       000 
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0x70, 0x1C, ##   000       000 
            0x70, 0x1C, ##   000       000 
            0x70, 0x1C, ##   000       000 
            0x3C, 0x78, ##    0000   0000  
            0x1F, 0xF0, ##     000000000   
            0x07, 0xC0, ##       00000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000    
            0xFF, 0xF8, ##  0000000000000  
            0xE0, 0x3C, ##  000       0000 
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x3C, ##  000       0000 
            0xFF, 0xF8, ##  0000000000000  
            0xFF, 0xE0, ##  00000000000    
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xC0, ##       00000     
            0x1F, 0xF0, ##     000000000   
            0x3C, 0x78, ##    0000   0000  
            0x70, 0x38, ##   000      000  
            0x70, 0x1C, ##   000       000 
            0x70, 0x1C, ##   000       000 
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0x70, 0x1C, ##   000       000 
            0x70, 0x1C, ##   000       000 
            0x70, 0x1C, ##   000       000 
            0x3C, 0x78, ##    0000   0000  
            0x1F, 0xF0, ##     000000000   
            0x07, 0xE0, ##       000000    
            0x00, 0x70, ##           000   
            0x00, 0x38, ##            000  
            0x00, 0x1C, ##             000 
            0x00, 0x10, ##             0   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 17, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xC0, 0x00, ##  0000000000       
            0xFF, 0xF0, 0x00, ##  000000000000     
            0xE0, 0x78, 0x00, ##  000      0000    
            0xE0, 0x38, 0x00, ##  000       000    
            0xE0, 0x1C, 0x00, ##  000        000   
            0xE0, 0x1C, 0x00, ##  000        000   
            0xE0, 0x1C, 0x00, ##  000        000   
            0xE0, 0x1C, 0x00, ##  000        000   
            0xE0, 0x1C, 0x00, ##  000        000   
            0xE0, 0x38, 0x00, ##  000       000    
            0xE0, 0x78, 0x00, ##  000      0000    
            0xFF, 0xE0, 0x00, ##  00000000000      
            0xFF, 0xC0, 0x00, ##  0000000000       
            0xE0, 0xE0, 0x00, ##  000     000      
            0xE0, 0x70, 0x00, ##  000      000     
            0xE0, 0x38, 0x00, ##  000       000    
            0xE0, 0x38, 0x00, ##  000       000    
            0xE0, 0x1C, 0x00, ##  000        000   
            0xE0, 0x1C, 0x00, ##  000        000   
            0xE0, 0x0E, 0x00, ##  000         000  
            0xE0, 0x0E, 0x00, ##  000         000  
            0xE0, 0x07, 0x00, ##  000          000 
            0xE0, 0x07, 0x00, ##  000          000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xF0, ##      00000000   
            0x1F, 0xFC, ##     00000000000 
            0x78, 0x1C, ##   0000      000 
            0x70, 0x04, ##   000         0 
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xF8, 0x00, ##  00000          
            0x7F, 0x00, ##   0000000       
            0x7F, 0xE0, ##   0000000000    
            0x1F, 0xF8, ##     0000000000  
            0x07, 0xFC, ##       000000000 
            0x00, 0x7C, ##           00000 
            0x00, 0x1E, ##             0000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x80, 0x1C, ##  0          000 
            0xF0, 0x3C, ##  0000      0000 
            0xFF, 0xF8, ##  0000000000000  
            0x1F, 0xE0, ##     00000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 18, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x01, 0xC0, 0x00, ##         000        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0x70, 0x1C, ##   000       000 
            0x78, 0x3C, ##   0000     0000 
            0x3F, 0xF8, ##    00000000000  
            0x0F, 0xE0, ##      0000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xE0, 0x03, 0x80, ##  000           000
            0xF0, 0x03, 0x80, ##  0000          000
            0x70, 0x07, 0x80, ##   000         0000
            0x70, 0x07, 0x00, ##   000         000 
            0x70, 0x07, 0x00, ##   000         000 
            0x38, 0x07, 0x00, ##    000        000 
            0x38, 0x0E, 0x00, ##    000       000  
            0x38, 0x0E, 0x00, ##    000       000  
            0x38, 0x0E, 0x00, ##    000       000  
            0x1C, 0x0E, 0x00, ##     000      000  
            0x1C, 0x1C, 0x00, ##     000     000   
            0x1C, 0x1C, 0x00, ##     000     000   
            0x0C, 0x1C, 0x00, ##      00     000   
            0x0E, 0x18, 0x00, ##      000    00    
            0x0E, 0x38, 0x00, ##      000   000    
            0x0E, 0x38, 0x00, ##      000   000    
            0x06, 0x30, 0x00, ##       00   00     
            0x07, 0x70, 0x00, ##       000 000     
            0x07, 0x70, 0x00, ##       000 000     
            0x03, 0x70, 0x00, ##        00 000     
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x01, 0xE0, 0x00, ##         0000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 19, 
        'xoffset'  => 0, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0x60, 0x00, 0xE0, ##   00             000
            0x70, 0x00, 0xE0, ##   000            000
            0x70, 0x00, 0xC0, ##   000            00 
            0x70, 0xE1, 0xC0, ##   000    000    000 
            0x70, 0xF1, 0xC0, ##   000    0000   000 
            0x71, 0xF1, 0xC0, ##   000   00000   000 
            0x71, 0xF1, 0xC0, ##   000   00000   000 
            0x31, 0xB1, 0xC0, ##    00   00 00   000 
            0x31, 0xB1, 0xC0, ##    00   00 00   000 
            0x39, 0xB9, 0x80, ##    000  00 000  00  
            0x3B, 0x99, 0x80, ##    000 000  00  00  
            0x3B, 0x1B, 0x80, ##    000 00   00 000  
            0x3B, 0x1B, 0x80, ##    000 00   00 000  
            0x3B, 0x1B, 0x80, ##    000 00   00 000  
            0x1B, 0x0F, 0x80, ##     00 00    00000  
            0x1F, 0x0F, 0x00, ##     00000    0000   
            0x1E, 0x0F, 0x00, ##     0000     0000   
            0x1E, 0x0F, 0x00, ##     0000     0000   
            0x1E, 0x0F, 0x00, ##     0000     0000   
            0x1E, 0x07, 0x00, ##     0000      000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 19, 
        'xoffset'  => 0, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x38, 0x01, 0xC0, ##    000          000 
            0x3C, 0x03, 0xC0, ##    0000        0000 
            0x1C, 0x03, 0x80, ##     000        000  
            0x0E, 0x07, 0x00, ##      000      000   
            0x0E, 0x0F, 0x00, ##      000     0000   
            0x07, 0x0E, 0x00, ##       000    000    
            0x07, 0x9C, 0x00, ##       0000  000     
            0x03, 0x9C, 0x00, ##        000  000     
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF0, 0x00, ##         00000       
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x01, 0xF8, 0x00, ##         000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0x9C, 0x00, ##        000  000     
            0x07, 0x1C, 0x00, ##       000   000     
            0x0F, 0x0E, 0x00, ##      0000    000    
            0x0E, 0x0F, 0x00, ##      000     0000   
            0x1E, 0x07, 0x00, ##     0000      000   
            0x1C, 0x03, 0x80, ##     000        000  
            0x38, 0x03, 0x80, ##    000         000  
            0x78, 0x01, 0xC0, ##   0000          000 
            0x70, 0x01, 0xE0, ##   000           0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xE0, 0x03, 0x80, ##  000           000
            0xF0, 0x07, 0x80, ##  0000         0000
            0x70, 0x07, 0x00, ##   000         000 
            0x38, 0x0E, 0x00, ##    000       000  
            0x38, 0x0E, 0x00, ##    000       000  
            0x1C, 0x1C, 0x00, ##     000     000   
            0x1C, 0x3C, 0x00, ##     000    0000   
            0x0E, 0x38, 0x00, ##      000   000    
            0x07, 0x70, 0x00, ##       000 000     
            0x07, 0x70, 0x00, ##       000 000     
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFE, ##  000000000000000 
            0xFF, 0xFE, ##  000000000000000 
            0x00, 0x1E, ##             0000 
            0x00, 0x3C, ##            0000  
            0x00, 0x38, ##            000   
            0x00, 0x78, ##           0000   
            0x00, 0x70, ##           000    
            0x00, 0xE0, ##          000     
            0x00, 0xE0, ##          000     
            0x01, 0xC0, ##         000      
            0x03, 0xC0, ##        0000      
            0x03, 0x80, ##        000       
            0x07, 0x00, ##       000        
            0x07, 0x00, ##       000        
            0x0E, 0x00, ##      000         
            0x1C, 0x00, ##     000          
            0x1C, 0x00, ##     000          
            0x38, 0x00, ##    000           
            0x38, 0x00, ##    000           
            0x70, 0x00, ##   000            
            0xE0, 0x00, ##  000             
            0xFF, 0xFF, ##  0000000000000000
            0xFF, 0xFF, ##  0000000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 7, 
        'xoffset'  => 7, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xFE, ##  0000000
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0x70, 0x00, ##   000           
            0x70, 0x00, ##   000           
            0x38, 0x00, ##    000          
            0x38, 0x00, ##    000          
            0x1C, 0x00, ##     000         
            0x1C, 0x00, ##     000         
            0x0E, 0x00, ##      000        
            0x0E, 0x00, ##      000        
            0x0E, 0x00, ##      000        
            0x07, 0x00, ##       000       
            0x07, 0x00, ##       000       
            0x03, 0x80, ##        000      
            0x03, 0x80, ##        000      
            0x01, 0xC0, ##         000     
            0x01, 0xC0, ##         000     
            0x00, 0xE0, ##          000    
            0x00, 0xE0, ##          000    
            0x00, 0x70, ##           000   
            0x00, 0x70, ##           000   
            0x00, 0x38, ##            000  
            0x00, 0x38, ##            000  
            0x00, 0x38, ##            000  
            0x00, 0x1C, ##             000 
            0x00, 0x1C, ##             000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 6, 
        'xoffset'  => 6, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xC0, 0x00, ##         000       
            0x03, 0xE0, 0x00, ##        00000      
            0x07, 0xF0, 0x00, ##       0000000     
            0x0F, 0x78, 0x00, ##      0000 0000    
            0x0E, 0x3C, 0x00, ##      000   0000   
            0x1C, 0x1C, 0x00, ##     000     000   
            0x38, 0x0E, 0x00, ##    000       000  
            0x70, 0x07, 0x00, ##   000         000 
            0x60, 0x03, 0x80, ##   00           000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 16, 
        'xoffset'  => 0, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFF, ##  0000000000000000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 8, 
        'xoffset'  => 4, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x70, ##   000    
            0x38, ##    000   
            0x38, ##    000   
            0x1C, ##     000  
            0x0E, ##      000 
            0x06, ##       00 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0xE0, ##     00000000    
            0x7F, 0xF8, ##   000000000000  
            0x70, 0x3C, ##   000      0000 
            0x40, 0x1C, ##   0         000 
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x0F, 0xFE, ##      00000000000
            0x3F, 0xFE, ##    0000000000000
            0x78, 0x0E, ##   0000       000
            0xF0, 0x0E, ##  0000        000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x1E, ##  000        0000
            0xE0, 0x3E, ##  000       00000
            0x70, 0x7E, ##   000     000000
            0x3F, 0xEE, ##    000000000 000
            0x1F, 0x8E, ##     000000   000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 14, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE7, 0xC0, ##  000  00000    
            0xEF, 0xE0, ##  000 0000000   
            0xF8, 0x70, ##  00000    000  
            0xF0, 0x38, ##  0000      000 
            0xF0, 0x38, ##  0000      000 
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xF0, 0x38, ##  0000      000 
            0xF0, 0x38, ##  0000      000 
            0xF8, 0x70, ##  00000    000  
            0xEF, 0xE0, ##  000 0000000   
            0xE7, 0xC0, ##  000  00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 14, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xF0, ##       0000000  
            0x1F, 0xFC, ##     00000000000
            0x3C, 0x1C, ##    0000     000
            0x78, 0x04, ##   0000        0
            0x70, 0x00, ##   000          
            0xF0, 0x00, ##  0000          
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xF0, 0x00, ##  0000          
            0x70, 0x00, ##   000          
            0x78, 0x04, ##   0000        0
            0x3C, 0x1C, ##    0000     000
            0x1F, 0xFC, ##     00000000000
            0x07, 0xF0, ##       0000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x0F, 0x9C, ##      00000  000
            0x1F, 0xDC, ##     0000000 000
            0x38, 0x7C, ##    000    00000
            0x70, 0x3C, ##   000      0000
            0x70, 0x3C, ##   000      0000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0x70, 0x3C, ##   000      0000
            0x70, 0x3C, ##   000      0000
            0x38, 0x7C, ##    000    00000
            0x1F, 0xDC, ##     0000000 000
            0x0F, 0x9C, ##      00000  000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xE0, ##       000000    
            0x1F, 0xF8, ##     0000000000  
            0x3C, 0x38, ##    0000    000  
            0x70, 0x1C, ##   000       000 
            0x70, 0x0E, ##   000        000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0x70, 0x00, ##   000           
            0x78, 0x04, ##   0000        0 
            0x3C, 0x1C, ##    0000     000 
            0x1F, 0xFC, ##     00000000000 
            0x07, 0xF0, ##       0000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 14, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xFC, ##          000000
            0x03, 0xFC, ##        00000000
            0x07, 0x80, ##       0000     
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x9C, ##      00000  000
            0x1F, 0xDC, ##     0000000 000
            0x38, 0x7C, ##    000    00000
            0x70, 0x3C, ##   000      0000
            0x70, 0x3C, ##   000      0000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0x70, 0x3C, ##   000      0000
            0x70, 0x3C, ##   000      0000
            0x38, 0x7C, ##    000    00000
            0x1F, 0xDC, ##     0000000 000
            0x0F, 0x9C, ##      00000  000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x38, ##            000 
            0x30, 0x78, ##    00     0000 
            0x3F, 0xF0, ##    0000000000  
            0x1F, 0xC0, ##     0000000    
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 13, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE7, 0xC0, ##  000  00000   
            0xEF, 0xF0, ##  000 00000000 
            0xF8, 0x70, ##  00000    000 
            0xF0, 0x78, ##  0000     0000
            0xF0, 0x38, ##  0000      000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 14, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x7F, 0x80, ##   00000000     
            0x7F, 0x80, ##   00000000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 9, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x7F, 0x80, ##   00000000
            0x7F, 0x80, ##   00000000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x07, 0x00, ##       000 
            0xFE, 0x00, ##  0000000  
            0xFC, 0x00, ##  000000   
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 15, 
        'xoffset'  => 4, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x3C, ##  000       0000 
            0xE0, 0x78, ##  000      0000  
            0xE0, 0xF0, ##  000     0000   
            0xE1, 0xC0, ##  000    000     
            0xE3, 0x80, ##  000   000      
            0xE7, 0x00, ##  000  000       
            0xEE, 0x00, ##  000 000        
            0xFF, 0x00, ##  00000000       
            0xFF, 0x00, ##  00000000       
            0xF3, 0x80, ##  0000  000      
            0xE3, 0xC0, ##  000   0000     
            0xE1, 0xE0, ##  000    0000    
            0xE0, 0xE0, ##  000     000    
            0xE0, 0xF0, ##  000     0000   
            0xE0, 0x78, ##  000      0000  
            0xE0, 0x38, ##  000       000  
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x1E, ##  000        0000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 13, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFE, 0x00, ##  0000000      
            0xFE, 0x00, ##  0000000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x07, 0x00, ##       000     
            0x03, 0xF8, ##        0000000
            0x01, 0xF8, ##         000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xEE, 0x38, ##  000 000   000  
            0xFF, 0x7C, ##  00000000 00000 
            0xF7, 0xDC, ##  0000 00000 000 
            0xE3, 0x8E, ##  000   000   000
            0xE3, 0x8E, ##  000   000   000
            0xE3, 0x8E, ##  000   000   000
            0xE3, 0x8E, ##  000   000   000
            0xE3, 0x8E, ##  000   000   000
            0xE3, 0x8E, ##  000   000   000
            0xE3, 0x8E, ##  000   000   000
            0xE3, 0x8E, ##  000   000   000
            0xE3, 0x8E, ##  000   000   000
            0xE3, 0x8E, ##  000   000   000
            0xE3, 0x8E, ##  000   000   000
            0xE3, 0x8E, ##  000   000   000
            0xE3, 0x8E, ##  000   000   000
            0xE3, 0x8E, ##  000   000   000
            0xE3, 0x8E, ##  000   000   000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 13, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE7, 0xC0, ##  000  00000   
            0xEF, 0xF0, ##  000 00000000 
            0xF8, 0x70, ##  00000    000 
            0xF0, 0x78, ##  0000     0000
            0xF0, 0x38, ##  0000      000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xC0, ##       00000     
            0x1F, 0xF0, ##     000000000   
            0x38, 0x38, ##    000     000  
            0x70, 0x1C, ##   000       000 
            0x70, 0x1C, ##   000       000 
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0x70, 0x1C, ##   000       000 
            0x70, 0x1C, ##   000       000 
            0x38, 0x38, ##    000     000  
            0x1F, 0xF0, ##     000000000   
            0x0F, 0xC0, ##      000000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 14, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE7, 0xC0, ##  000  00000    
            0xEF, 0xE0, ##  000 0000000   
            0xF8, 0x70, ##  00000    000  
            0xF0, 0x38, ##  0000      000 
            0xF0, 0x38, ##  0000      000 
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xF0, 0x38, ##  0000      000 
            0xF0, 0x38, ##  0000      000 
            0xF8, 0x70, ##  00000    000  
            0xEF, 0xE0, ##  000 0000000   
            0xE7, 0xC0, ##  000  00000    
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x9C, ##      00000  000
            0x1F, 0xDC, ##     0000000 000
            0x38, 0x7C, ##    000    00000
            0x70, 0x3C, ##   000      0000
            0x70, 0x3C, ##   000      0000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0xE0, 0x1C, ##  000        000
            0x70, 0x3C, ##   000      0000
            0x70, 0x3C, ##   000      0000
            0x38, 0x7C, ##    000    00000
            0x1F, 0xDC, ##     0000000 000
            0x0F, 0x9C, ##      00000  000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 13, 
        'xoffset'  => 6, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE3, 0xF0, ##  000   000000 
            0xEF, 0xF8, ##  000 000000000
            0xFC, 0x18, ##  000000     00
            0xF8, 0x00, ##  00000        
            0xF0, 0x00, ##  0000         
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 13, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0xE0, ##     00000000  
            0x3F, 0xF0, ##    0000000000 
            0x70, 0x30, ##   000      00 
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xF0, 0x00, ##  0000         
            0xFF, 0x00, ##  00000000     
            0x7F, 0xE0, ##   0000000000  
            0x1F, 0xF0, ##     000000000 
            0x01, 0xF8, ##         000000
            0x00, 0x78, ##           0000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0xE0, 0xF0, ##  000     0000 
            0xFF, 0xE0, ##  00000000000  
            0x3F, 0x80, ##    0000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x03, 0x80, ##        000     
            0x03, 0xFC, ##        00000000
            0x00, 0xFC, ##          000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 13, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xF0, 0x78, ##  0000     0000
            0x70, 0xF8, ##   000    00000
            0x7F, 0xB8, ##   00000000 000
            0x1F, 0x38, ##     00000  000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x07, ##  000          000
            0xE0, 0x0E, ##  000         000 
            0xE0, 0x0E, ##  000         000 
            0x70, 0x0E, ##   000        000 
            0x70, 0x1C, ##   000       000  
            0x70, 0x1C, ##   000       000  
            0x38, 0x18, ##    000      00   
            0x38, 0x38, ##    000     000   
            0x38, 0x38, ##    000     000   
            0x1C, 0x70, ##     000   000    
            0x1C, 0x70, ##     000   000    
            0x0C, 0x70, ##      00   000    
            0x0E, 0xE0, ##      000 000     
            0x0E, 0xE0, ##      000 000     
            0x06, 0xE0, ##       00 000     
            0x07, 0xC0, ##       00000      
            0x07, 0xC0, ##       00000      
            0x03, 0xC0, ##        0000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 19, 
        'xoffset'  => 0, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0x60, 0x00, 0xE0, ##   00             000
            0x70, 0x00, 0xC0, ##   000            00 
            0x70, 0x01, 0xC0, ##   000           000 
            0x70, 0xE1, 0xC0, ##   000    000    000 
            0x70, 0xE1, 0xC0, ##   000    000    000 
            0x30, 0xE1, 0xC0, ##    00    000    000 
            0x38, 0xF1, 0x80, ##    000   0000   00  
            0x39, 0xB3, 0x80, ##    000  00 00  000  
            0x39, 0xB3, 0x80, ##    000  00 00  000  
            0x19, 0x9B, 0x80, ##     00  00  00 000  
            0x1B, 0x1B, 0x00, ##     00 00   00 00   
            0x1F, 0x1B, 0x00, ##     00000   00 00   
            0x1F, 0x1F, 0x00, ##     00000   00000   
            0x0F, 0x0F, 0x00, ##      0000    0000   
            0x0E, 0x0F, 0x00, ##      000     0000   
            0x0E, 0x0E, 0x00, ##      000     000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x70, 0x07, 0x00, ##   000         000 
            0x38, 0x0E, 0x00, ##    000       000  
            0x1C, 0x1E, 0x00, ##     000     0000  
            0x1C, 0x1C, 0x00, ##     000     000   
            0x0E, 0x38, 0x00, ##      000   000    
            0x07, 0x70, 0x00, ##       000 000     
            0x03, 0xF0, 0x00, ##        000000     
            0x03, 0xE0, 0x00, ##        00000      
            0x01, 0xC0, 0x00, ##         000       
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xF0, 0x00, ##        000000     
            0x07, 0x70, 0x00, ##       000 000     
            0x0E, 0x38, 0x00, ##      000   000    
            0x1E, 0x1C, 0x00, ##     0000    000   
            0x1C, 0x1E, 0x00, ##     000     0000  
            0x38, 0x0E, 0x00, ##    000       000  
            0x78, 0x07, 0x00, ##   0000        000 
            0x70, 0x07, 0x80, ##   000         0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0x70, 0x0E, ##   000        000 
            0x70, 0x0E, ##   000        000 
            0x70, 0x1C, ##   000       000  
            0x38, 0x1C, ##    000      000  
            0x38, 0x1C, ##    000      000  
            0x18, 0x38, ##     00     000   
            0x1C, 0x38, ##     000    000   
            0x1C, 0x38, ##     000    000   
            0x0E, 0x70, ##      000  000    
            0x0E, 0x70, ##      000  000    
            0x0E, 0x60, ##      000  00     
            0x07, 0xE0, ##       000000     
            0x07, 0xE0, ##       000000     
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0x80, ##        000       
            0x03, 0x80, ##        000       
            0x03, 0x00, ##        00        
            0x07, 0x00, ##       000        
            0x0F, 0x00, ##      0000        
            0x7E, 0x00, ##   000000         
            0x7C, 0x00, ##   00000          
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 13, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x38, ##            000
            0x00, 0x70, ##           000 
            0x00, 0xE0, ##          000  
            0x01, 0xE0, ##         0000  
            0x01, 0xC0, ##         000   
            0x03, 0x80, ##        000    
            0x07, 0x00, ##       000     
            0x0F, 0x00, ##      0000     
            0x0E, 0x00, ##      000      
            0x1C, 0x00, ##     000       
            0x38, 0x00, ##    000        
            0x38, 0x00, ##    000        
            0x70, 0x00, ##   000         
            0xE0, 0x00, ##  000          
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 13, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xF8, ##          00000
            0x03, 0xF8, ##        0000000
            0x07, 0x80, ##       0000    
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x0E, 0x00, ##      000      
            0xFC, 0x00, ##  000000       
            0xFC, 0x00, ##  000000       
            0x0E, 0x00, ##      000      
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x80, ##       0000    
            0x03, 0xF8, ##        0000000
            0x00, 0xF8, ##          00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 3, 
        'xoffset'  => 8, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 12, 
        'xoffset'  => 4, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0x00, ##  0000        
            0xFC, 0x00, ##  000000      
            0x1C, 0x00, ##     000      
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x07, 0x00, ##       000    
            0x03, 0xF0, ##        000000
            0x03, 0xF0, ##        000000
            0x07, 0x00, ##       000    
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x1E, 0x00, ##     0000     
            0xFC, 0x00, ##  000000      
            0xF0, 0x00, ##  0000        
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x3F, 0x00, 0x80, ##    000000        0
            0xFF, 0xC1, 0x80, ##  0000000000     00
            0xC1, 0xFF, 0x80, ##  00     0000000000
            0x80, 0x3E, 0x00, ##  0         00000  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 10, 
        'xoffset'  => 5, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x00, ##     0000   
            0x7F, 0x80, ##   00000000 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x7F, 0x80, ##   00000000 
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { },  # A
    '66' => { },  # B
    '67' => { },  # C
    '68' => { },  # D
    '69' => { },  # E
    '70' => { },  # F
    '71' => { },  # G
    '72' => { },  # H
    '73' => { },  # I
    '74' => { },  # J
    '75' => { },  # K
    '76' => { },  # L
    '77' => { },  # M
    '78' => { },  # N
    '79' => { },  # O
    '80' => { },  # P
    '81' => { },  # Q
    '82' => { },  # R
    '83' => { },  # S
    '84' => { },  # T
    '85' => { },  # U
    '86' => { },  # V
    '87' => { },  # W
    '88' => { },  # X
    '89' => { },  # Y
    '90' => { },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { },  # e
    '102' => { },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { },  # v
    '119' => { },  # w
    '120' => { },  # x
    '121' => { },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '176' => { },  # °
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
