#define XERR "memoryaccess"
#include "memoryaccess.ih"

    // by cptsizes.cc

    // each segment is at least s_minimum pages large, s_minimum segments can
    // be used before extend is called.

// static
void MemoryAccess::kiloBytes(size_t *nBlocks, size_t *blockSize, 
                             size_t factor) 
{
                                    // #pages covering the requested size
    size_t nPages = divPlus(factor * 1024, s_pageSize);

    size_t pps = divPlus(nPages, 16);   // required pages per segment

                                    // size of the mem. segments
    *blockSize = max(s_minimum, pps) * s_pageSize;    

                                    // #potentially avail. segments
    *nBlocks = max(s_minimum, divPlus(nPages, pps));
}
