/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.EventObject;
import org.opensolaris.os.dtrace.ProbeData;

public class DataEvent
extends EventObject {
    static final long serialVersionUID = 3068774547474769821L;
    private ProbeData probeData;

    public DataEvent(Object source, ProbeData generatedData) {
        super(source);
        this.probeData = generatedData;
        this.validate();
    }

    private final void validate() {
        if (this.probeData == null) {
            throw new NullPointerException("probe data is null");
        }
    }

    public ProbeData getProbeData() {
        return this.probeData;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(DataEvent.class.getName());
        buf.append("[source = ");
        buf.append(this.getSource());
        buf.append(", probeData = ");
        buf.append(this.probeData);
        buf.append(']');
        return buf.toString();
    }
}

